'use strict';

/* --------------------------------------------------------------
 DebugBar.js 2018-02-23
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2018 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Debug Bar JavaScript Enhancements
 *
 * This module will perform some adjustments to the default PHP Debug Bar instance.
 */
$(function () {
    'use strict';

    var $debugBar = $('.phpdebugbar');

    if (!$debugBar.length) {
        return; // The Debug Bar is not loaded on this page or could not be detected.
    }

    // Remove the message counter from "Help" section.
    var $help = $debugBar.find('.phpdebugbar-text').filter(function () {
        return $(this).text().indexOf('Help') !== -1;
    });

    if ($help.length) {
        $help.next().remove(); // Remove the counter element.		
    }

    // Remove unnecessary line break element added by the Debug Bar when minimized.
    $debugBar.on('click', '.phpdebugbar-close-btn', function () {
        $debugBar.next('br').remove();
    });

    $debugBar.on('click', '.phpdebugbar-restore-btn', function () {
        $('<br/>').insertAfter($debugBar);
    });

    if ($debugBar.hasClass('phpdebugbar-closed')) {
        $debugBar.next('br').remove();
    }

    // Correct initial display of Debug Bar in admin layout pages.
    if ($('aside#main-menu').length) {
        setTimeout(function () {
            phpdebugbar.resize();
        }, 2000);
    }

    // Set default initial Debug Bar state to minimized.
    phpdebugbar.minimize();
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
